package gov.va.med.mhv.usermgmt.web.controller;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.web.context.WebApplicationContext;

import com.liferay.portal.util.PortalUtil;

import gov.va.med.mhv.common.api.dto.UserProfileDTO;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.usermgmt.common.dto.ActivityDTO;
import gov.va.med.mhv.usermgmt.common.enums.ActivityActionTypeEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.ActivityTypeEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.PasswordHintQuestionsEnumeration;
import gov.va.med.mhv.usermgmt.web.formbean.ForgotPassword;

/**
 * @author vhaiswsilver
 * 
 */
@ManagedBean
@Component
@Scope(WebApplicationContext.SCOPE_SESSION)
public class ForgotPasswordController extends AbstractController implements
		Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = -9191875686222494443L;
	
	private static Logger logger = LogManager.getLogger(ForgotPasswordController.class);

	private static String STEP_1 = "STEP_1";
	private static String STEP_2 = "STEP_2";
	private static String STEP_3 = "STEP_3";
	private static String STEP_4 = "STEP_4";
	
	private String currentStep = STEP_1;
	
	@Autowired
	private ForgotPassword forgotPassword;
//	private ChangePassword changePassword;
	
	
	public ForgotPassword getForgotPassword() {
		return forgotPassword;
	}

	public void setForgotPassword(ForgotPassword forgotPassword) {
		this.forgotPassword = forgotPassword;
	}
	private UserProfileDTO userProfile = null;
	
	private String userName;
	
	public void viewControl() {
		javax.portlet.RenderRequest request = (javax.portlet.RenderRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();

		HttpServletRequest httpReq = PortalUtil.getOriginalServletRequest(PortalUtil.getHttpServletRequest(request));
		String action = httpReq.getParameter("action");

		if( "new".equals(action) ) {
			currentStep = STEP_1;
			this.forgotPassword = new ForgotPassword();
		} 
	}
	
	public String step1Action() {
		FacesContext context = FacesContext.getCurrentInstance();
		logger.debug("ForgotUserController.step1Action");

		int day = Integer.parseInt(forgotPassword.getDay());  
		int month = Integer.parseInt(forgotPassword.getMonth()); 
		int year = Integer.parseInt(forgotPassword.getYear()); 
		boolean errorOccured=false;

		Calendar c = Calendar.getInstance();
		
	    c.set(Calendar.YEAR, year);
	    c.set(Calendar.MONTH, month-1);
	    c.set(Calendar.DAY_OF_MONTH, day);
	    c.set(Calendar.HOUR_OF_DAY,0);
	    c.set(Calendar.SECOND, 0);
	    c.set(Calendar.MINUTE, 0);
	    c.set(Calendar.MILLISECOND, 0);
		
		
		
		Date birthDate = c.getTime();
		userProfile = new UserProfileDTO();

		String firstName = forgotPassword.getFirstName();
		if( firstName == null || firstName.length() == 0 ) {
			FacesContext.getCurrentInstance().addMessage(
					null,
					new FacesMessage(FacesMessage.SEVERITY_ERROR,
							"First name is a required field.", "General error."));
		}
		userProfile.setFirstName(firstName);

		String lastName = forgotPassword.getLastName();
		if( lastName == null || lastName.length() == 0 ) {
			FacesContext.getCurrentInstance().addMessage(
					null,
					new FacesMessage(FacesMessage.SEVERITY_ERROR,
							"Last name is a required field.", "General error."));
		}
		userProfile.setLastName(lastName);

		String userName = forgotPassword.getUserName();
		if( userName == null || userName.length() == 0 ) {
			FacesContext.getCurrentInstance().addMessage(
					null,
					new FacesMessage(FacesMessage.SEVERITY_ERROR,
							"User ID is a required field.", "General error."));
		}
		userProfile.setUserName(userName);

		if( FacesContext.getCurrentInstance().getMessageList().size() > 0 ) {
			
			context.getApplication().getNavigationHandler().
	        handleNavigation(context, null, "/views/account/forgot/forgotPasswordStep1.xhtml");
			return null;
		}

		userProfile.setGender(forgotPassword.getGender());
		userProfile.setBirthDate(birthDate);

		try {
			
			userProfile = this.accountValidatorService.getUserProfileForUserName(userProfile.getFirstName(), userProfile.getLastName(), userProfile.getUserName(), userProfile.getGender(), userProfile.getBirthDate());
			
			
			currentStep = STEP_2;
			logger.debug("ChangePasswordController - success");
			
			int q1 = userProfile.getPasswordHintQuestion1();
			int q2 = userProfile.getPasswordHintQuestion2();
			
			for (PasswordHintQuestionsEnumeration s : PasswordHintQuestionsEnumeration.values()) {
				if (s.getValue() == q1) {
					forgotPassword.setQuestion1(s.getDescription());
				}
				if (s.getValue() == q2) {
					forgotPassword.setQuestion2(s.getDescription());
				}
			}
			
		}catch (MHVException e) {
			if(userProfile.getId() == null ) {
				
				FacesContext.getCurrentInstance().addMessage(
						null,
						new FacesMessage(FacesMessage.SEVERITY_ERROR,
								"A user could not be found with the specified profile.", "General error."));
				return null;
				
			}
			String errorMessage=e.getFailureMessage();
			context.addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, errorMessage, errorMessage));
			return null;
		}
		
		catch (Exception e) {
			 errorOccured=true;
			currentStep = STEP_1;
			logger.debug("ChangePasswordController - saveContactAction - fail");
			
				FacesContext.getCurrentInstance().addMessage(
						null,
						new FacesMessage(FacesMessage.SEVERITY_ERROR,
								"A user could not be found with the specified profile.", "General error."));
			logger.debug("ChangePasswordController - exception "
					+ e.getMessage());
			
		}
		if (errorOccured) {
			context.getApplication().getNavigationHandler().
			handleNavigation(context, null, "/views/account/forgot/forgotPasswordStep1.xhtml");
		}
		else {
			context.getApplication().getNavigationHandler().
	        handleNavigation(context, null, "/views/account/forgot/forgotPasswordStep2.xhtml");
		}
		
		return null;
	}

	public String step2Action() {
		FacesContext context = FacesContext.getCurrentInstance();
		if( userProfile == null ) {
			FacesContext.getCurrentInstance().addMessage(
					null,
					new FacesMessage(FacesMessage.SEVERITY_ERROR,
							"Before we can proceed, the answer to at least one of your two Password Hint questions must be correct.", "NULL_ANSWER"));
			FacesContext.getCurrentInstance().addMessage(
					null,
					new FacesMessage(FacesMessage.SEVERITY_ERROR,
							"Your answers did not match what you gave when you registered on My HealtheVet.", "NULL_ANSWER"));
			context.getApplication().getNavigationHandler().
	        handleNavigation(context, null, "/views/account/forgot/viewForgotPassword.xhtml");
			return null;
		}
		String answer1 = forgotPassword.getAnswer1();
		String answer2 = forgotPassword.getAnswer2();
		if( answer1 == null || answer1.length() == 0 || answer2 == null || answer2.length() == 0 ) {
			FacesContext.getCurrentInstance().addMessage(
					null,
					new FacesMessage(FacesMessage.SEVERITY_ERROR,
							"Before we can proceed, the answer to at least one of your two Password Hint questions must be correct.", "NULL_ANSWER"));
			FacesContext.getCurrentInstance().addMessage(
					null,
					new FacesMessage(FacesMessage.SEVERITY_ERROR,
							"Your answers did not match what you gave when you registered on My HealtheVet.", "NULL_ANSWER"));
			context.getApplication().getNavigationHandler().
	        handleNavigation(context, null, "/views/account/forgot/viewForgotPassword.xhtml");
			return null;
		} else {
			String answer1a = userProfile.getPasswordHintAnswer1();
			String answer2a = userProfile.getPasswordHintAnswer2();
			
			if( ! answer1.equalsIgnoreCase(answer1a) && ! answer2.equalsIgnoreCase(answer2a))  {
				FacesContext.getCurrentInstance().addMessage(
						null,
						new FacesMessage(FacesMessage.SEVERITY_ERROR,
								"Before we can proceed, the answer to at least one of your two Password Hint questions must be correct. ", "NULL_ANSWER"));
				FacesContext.getCurrentInstance().addMessage(
						null,
						new FacesMessage(FacesMessage.SEVERITY_ERROR,
								"Your answers did not match what you gave when you registered on My HealtheVet.", "NULL_ANSWER"));
				context.getApplication().getNavigationHandler().
		        handleNavigation(context, null, "/views/account/forgot/forgotPasswordStep2.xhtml");
				return null;
			}
//			if( ! answer2.equalsIgnoreCase(answer2a) )  {
//				FacesContext.getCurrentInstance().addMessage(
//						null,
//						new FacesMessage(FacesMessage.SEVERITY_ERROR,
//								"Before we can proceed, the answer to at least one of your two Password Hint questions must be correct. ", "NULL_ANSWER"));
//				FacesContext.getCurrentInstance().addMessage(
//						null,
//						new FacesMessage(FacesMessage.SEVERITY_ERROR,
//								"Your answers did not match what you gave when you registered on My HealtheVet.", "NULL_ANSWER"));
//				return "";
//			}
		}
		userName = userProfile.getUserName();
		
		currentStep = STEP_3;
		context.getApplication().getNavigationHandler().
        handleNavigation(context, null, "/views/account/forgot/forgotPasswordStep3.xhtml");
		return null;
	}

	public String step3Action() {
		logger.debug("ForgotPasswordController - Gson created");
		FacesContext context = FacesContext.getCurrentInstance();

		userProfile.setPassword(this.forgotPassword.getPassword());
		userProfile.setConfPassword(this.forgotPassword.getConfirmPassword());

		
		validatePassword(this.userProfile,false);
		
		if( FacesContext.getCurrentInstance().getMessageList().size() > 0 ) {
			
			context.getApplication().getNavigationHandler().
	        handleNavigation(context, null, "/views/account/forgot/forgotPasswordStep3.xhtml");
			return null;
		}
		
		try {
			
			userProfile = this.accountValidatorService.changePassword(this.userProfile,Boolean.TRUE);
			
			logger.debug("ChangePasswordController - saveContactAction - success");
			FacesContext
					.getCurrentInstance()
					.addMessage(
							null,
							new FacesMessage(
									FacesMessage.SEVERITY_INFO,
									"You have successfully changed your password.",
									"SUCCESS"));
			this.forgotPassword = new ForgotPassword();

			currentStep = STEP_4;
			
		} catch(MHVException ex) {
			
			super.processErrorMessages(ex);
			context.getApplication().getNavigationHandler().
	        	handleNavigation(context, null, "/views/account/forgot/forgotPasswordStep3.xhtml");
			return null;
		
		} 
		
		context.getApplication().getNavigationHandler().
        	handleNavigation(context, null, "/views/account/forgot/forgotPasswordStep4.xhtml");
		return null;
	}
	

	public String getCurrentStep() {
		return currentStep;
	}

	public void setCurrentStep(String currentStep) {
		this.currentStep = currentStep;
	}

	public String getUserName() {
		this.currentStep = STEP_1;
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}
	
}